/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.launch.hscmgt;

import com.ibm.hsc.auiml.databeans.network.IPBeans;
import com.ibm.hsc.auiml.databeans.network.NameDNSBean;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.Crypt;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hwmca.common.log.ClassLogInfo;
import com.ibm.ui.framework.swing.ChoiceDescriptor;
import com.ibm.ui.framework.swing.DataBean;
import com.ibm.ui.framework.swing.ItemDescriptor;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class NetworkSettings {
    private static final String TRACE_MASKD = "JNETSETD";
    private static final String TRACE_MASKF = "JNETSETF";
    private static final String TRACE_MASKT = "JNETSETT";
    private static ClassLogInfo _logInfo = new ClassLogInfo(-88, 97, "NetworkSettings");
    private static final short ERRID_0001 = 1;
    private static final short ERRID_0002 = 2;
    private static final short ERRID_0003 = 3;
    private static final short ERRID_0004 = 4;
    private static final short ERRID_0005 = 5;
    private static final short ERRID_0006 = 6;
    private static final short ERRID_0007 = 7;
    private static final short ERRID_0008 = 8;
    private static final short ERRID_0009 = 9;
    private static final short ERRID_000A = 10;
    private static final short ERRID_000B = 11;
    private static final short ERRID_000C = 12;
    private static final short ERRID_000D = 13;
    private static final short ERRID_000E = 14;
    private static final short ERRID_000F = 15;
    private static final short ERRID_0010 = 16;
    private static final short ERRID_0011 = 17;
    private static final short ERRID_0012 = 18;
    private static final short ERRID_0013 = 19;
    private static final short ERRID_0014 = 20;
    private static final String DIRECTORY = "/etc/sysconfig/network/";
    private static final String PREFIX = "ifcfg-";
    private static final String STATIC_ROUTES_FILE = "/etc/sysconfig/network/routes";
    private static final String ETHERNET_CONFIG_FILE = "/etc/modules.conf";
    private static final String HOSTS_FILE = "/etc/hosts";
    private static final String DNS_FILE = "/etc/resolv.conf";
    private static final String HOSTNAME_FILE = "/etc/HOSTNAME";
    private static final File TEMP_DIR = new File("/tmp/");
    private static final String ETHTOOL_PREFIX = "#tg3 /usr/sbin/ethtool -s ";
    private static final String HSC_DO_CMD_EXECUTABLE = "/opt/hsc/bin/hscdc";
    private static String[] SPEEDS = null;

    public static String getAttrValue(String string, Properties properties) {
        String string2 = properties.getProperty(string, "").trim();
        int n = string2.length();
        if (n > 1) {
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, n - 1);
            } else if (string2.startsWith("'") && string2.endsWith("'")) {
                string2 = string2.substring(1, n - 1);
            }
        }
        return string2;
    }

    private static String readMultipleFileContents(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            stringBuffer.append("echo 'FILE NAME:***");
            stringBuffer.append(string);
            stringBuffer.append("***';");
            stringBuffer.append(HSC_DO_CMD_EXECUTABLE);
            stringBuffer.append(" ");
            stringBuffer.append(Crypt.encrypt("cat"));
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append(";");
        }
        return NetworkSettings.executeCommandGetStdOut(stringBuffer.toString());
    }

    private static String getFileContents(String string, String string2) {
        String string3 = "";
        String string4 = "FILE NAME:***" + string + "***\n";
        int n = string2.indexOf(string4);
        if (n != -1) {
            int n2 = string2.indexOf("FILE NAME:***", n += string4.length());
            if (n2 == -1) {
                n2 = string2.length();
            }
            string3 = string2.substring(n, n2);
        }
        return string3;
    }

    private static void prepareFileRewrite(String string, String string2, String string3, StringBuffer stringBuffer, ArrayList arrayList) throws IOException {
        if (!string2.equals(string3)) {
            File file = File.createTempFile("tmp", "", TEMP_DIR);
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string2);
            bufferedWriter.close();
            stringBuffer.append(HSC_DO_CMD_EXECUTABLE);
            stringBuffer.append(" ");
            stringBuffer.append(Crypt.encrypt("cp"));
            stringBuffer.append(" -f ");
            stringBuffer.append(file.getPath());
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append(";");
            arrayList.add(file);
        }
    }

    public static synchronized String[] getSpeeds() {
        block2: {
            if (SPEEDS != null) break block2;
            String string = "com.ibm.hsc.auiml.databeans.network.ipaddrAuiml";
            SPEEDS = new String[7];
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
                NetworkSettings.SPEEDS[0] = resourceBundle.getString("MediaSpeedPanel.0.VALUE");
                NetworkSettings.SPEEDS[1] = resourceBundle.getString("MediaSpeedPanel.1.VALUE");
                NetworkSettings.SPEEDS[2] = resourceBundle.getString("MediaSpeedPanel.2.VALUE");
                NetworkSettings.SPEEDS[3] = resourceBundle.getString("MediaSpeedPanel.3.VALUE");
                NetworkSettings.SPEEDS[4] = resourceBundle.getString("MediaSpeedPanel.4.VALUE");
                NetworkSettings.SPEEDS[5] = resourceBundle.getString("MediaSpeedPanel.5.VALUE");
                NetworkSettings.SPEEDS[6] = resourceBundle.getString("MediaSpeedPanel.6.VALUE");
            }
            catch (MissingResourceException missingResourceException) {
                Trace.trace(TRACE_MASKF, "NetworkSettings unable to retrieve medias speeed pulldown labels from ResourceBundle " + string);
                NetworkSettings.SPEEDS[0] = "Autodetection";
                NetworkSettings.SPEEDS[1] = "10Mbps Half Duplex";
                NetworkSettings.SPEEDS[2] = "10Mbps Full Duplex";
                NetworkSettings.SPEEDS[3] = "100Mbps Half Duplex";
                NetworkSettings.SPEEDS[4] = "100Mbps Full Duplex";
                NetworkSettings.SPEEDS[5] = "1000Mbps Half Duplex";
                NetworkSettings.SPEEDS[6] = "1000Mbps Full Duplex";
            }
        }
        return SPEEDS;
    }

    public static synchronized String getCorrectedMediaSpeed(String string, boolean bl) {
        NetworkSettings.getSpeeds();
        String string2 = string;
        if (bl) {
            try {
                int n = Integer.parseInt(string);
                string2 = SPEEDS[n];
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            int n = 0;
            while (n < SPEEDS.length) {
                if (string.equals(SPEEDS[n])) {
                    string2 = Integer.toString(n);
                    break;
                }
                ++n;
            }
        }
        return string2;
    }

    public static DataBean[] GetIPSettings() {
        String[] stringArray;
        String[] stringArray2;
        Object object;
        Serializable serializable;
        String string;
        StringTokenizer stringTokenizer;
        Object object2;
        Object object3;
        String string2;
        Object object4;
        Object object5;
        String string3;
        String string4;
        String string5;
        Object object6;
        StringTokenizer stringTokenizer2;
        String string6;
        String string7;
        int n;
        String string8;
        Object object7;
        Object[] objectArray;
        Trace.trace(TRACE_MASKT, "-> NetworkSettings.GetIPSettings()");
        Properties properties = null;
        IPBeans iPBeans = new IPBeans();
        iPBeans.setDevName0("");
        iPBeans.setDevName1("");
        String string9 = "***RESULTS OF LS COMMAND***";
        String string10 = "/sbin/ifconfig; echo '" + string9 + "'; " + HSC_DO_CMD_EXECUTABLE + " " + Crypt.encrypt("ls") + " -1 " + DIRECTORY;
        String string11 = NetworkSettings.executeCommandGetStdOut(string10);
        int n2 = string11.indexOf(string9);
        String string12 = "";
        String string13 = "";
        if (n2 != -1) {
            string12 = string11.substring(0, n2);
            string13 = string11.substring(n2 + string9.length());
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith(NetworkSettings.PREFIX) && string.indexOf(".") == -1 && !string.equals("ifcfg-lo");
            }
        };
        File file = new File(DIRECTORY);
        StringTokenizer stringTokenizer3 = new StringTokenizer(string13);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (stringTokenizer3.hasMoreTokens()) {
            objectArray = stringTokenizer3.nextToken();
            if (!filenameFilter.accept(file, (String)objectArray)) continue;
            arrayList.add(objectArray);
        }
        objectArray = new String[arrayList.size()];
        objectArray = arrayList.toArray(objectArray);
        Arrays.sort(objectArray);
        int n3 = 0;
        while (n3 < objectArray.length) {
            arrayList.set(n3, DIRECTORY + (String)objectArray[n3]);
            ++n3;
        }
        arrayList.add(STATIC_ROUTES_FILE);
        arrayList.add(ETHERNET_CONFIG_FILE);
        arrayList.add(DNS_FILE);
        arrayList.add(HOSTS_FILE);
        arrayList.add(HOSTNAME_FILE);
        String string14 = NetworkSettings.readMultipleFileContents(arrayList);
        iPBeans.setNumberOfLanAdapters(0);
        int n4 = 0;
        while (n4 < objectArray.length) {
            properties = new Properties();
            try {
                object7 = NetworkSettings.getFileContents(DIRECTORY + (String)objectArray[n4], string14);
                properties.load(new ByteArrayInputStream(((String)object7).getBytes()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object7 = ((String)objectArray[n4]).substring(PREFIX.length());
            if (((String)object7).length() != 0) {
                string8 = "00:00:00:00:00:00";
                boolean bl = false;
                n = string12.indexOf((String)object7);
                if (n != -1) {
                    int n5;
                    block11: do {
                        n5 = string12.indexOf(10, n);
                        int n6 = 0;
                        int n7 = string12.lastIndexOf(":", n5);
                        while (n < n7) {
                            ++n6;
                            if (string12.startsWith(":", n7 - 3)) {
                                n7 -= 3;
                                continue;
                            }
                            if (5 == n6) {
                                string8 = string12.substring(n7 - 2, n7 + 15);
                                bl = true;
                                continue block11;
                            }
                            n6 = 0;
                            n7 = string12.lastIndexOf(":", n7 - 1);
                        }
                    } while ((n = string12.indexOf((String)object7 + ": ", n5 + 1)) != -1 && !bl);
                }
                if (bl) {
                    iPBeans.setNumberOfLanAdapters(iPBeans.getNumberOfLanAdapters() + 1);
                    iPBeans.setLanAddr(n4, string8 + " (" + (String)object7 + ")");
                    iPBeans.setDevName(n4, (String)object7);
                } else if (iPBeans.getDevName(n4).length() == 0) {
                    iPBeans.setDevName(n4, (String)object7);
                }
            }
            string8 = NetworkSettings.getAttrValue("IPADDR", properties);
            iPBeans.setIPAddr(n4, string8);
            string7 = NetworkSettings.getAttrValue("NETMASK", properties);
            iPBeans.setMask(n4, string7);
            ++n4;
        }
        string12 = NetworkSettings.getFileContents(STATIC_ROUTES_FILE, string14);
        object7 = new StringTokenizer(string12, "\n");
        string8 = "";
        string7 = "";
        n = 0;
        ArrayList<ItemDescriptor> arrayList2 = new ArrayList<ItemDescriptor>();
        ArrayList<ItemDescriptor> arrayList3 = new ArrayList<ItemDescriptor>();
        ArrayList<ItemDescriptor> arrayList4 = new ArrayList<ItemDescriptor>();
        ArrayList<ItemDescriptor> arrayList5 = new ArrayList<ItemDescriptor>();
        ArrayList<ItemDescriptor> arrayList6 = new ArrayList<ItemDescriptor>();
        int n8 = 0;
        while (((StringTokenizer)object7).hasMoreTokens()) {
            string6 = ((StringTokenizer)object7).nextToken().trim();
            stringTokenizer2 = new StringTokenizer(string6);
            if (string6.startsWith("default") && n == 0) {
                n = 1;
                object6 = new String[4];
                int n9 = 0;
                while (n9 <= 3 && stringTokenizer2.hasMoreTokens()) {
                    object6[n9] = "-";
                    if (stringTokenizer2.hasMoreTokens()) {
                        object6[n9] = stringTokenizer2.nextToken().trim();
                    }
                    ++n9;
                }
                string8 = object6[1];
                if (!object6[3].equals("-")) {
                    string7 = object6[3];
                    continue;
                }
                if (string8.length() <= 0) continue;
                if (iPBeans.getDevName0() != null && iPBeans.getDevName0().length() > 0) {
                    string7 = iPBeans.getDevName0();
                    continue;
                }
                if (iPBeans.getDevName1() == null || iPBeans.getDevName1().length() <= 0) continue;
                string7 = iPBeans.getDevName1();
                continue;
            }
            if (string6.startsWith("#") || string6.length() == 0) continue;
            boolean bl = false;
            String string15 = "-";
            string5 = "-";
            string4 = "-";
            string3 = "-";
            int n10 = 0;
            while (stringTokenizer2.hasMoreTokens() && n10 < 4) {
                object5 = stringTokenizer2.nextToken().trim();
                switch (n10) {
                    case 0: {
                        string15 = object5;
                        break;
                    }
                    case 1: {
                        string5 = object5;
                        break;
                    }
                    case 2: {
                        string4 = object5;
                        break;
                    }
                    case 3: {
                        string3 = object5;
                    }
                }
                ++n10;
            }
            if (n10 <= 0) continue;
            arrayList2.add(new ItemDescriptor(string15 + "_static_dest" + n8, string15));
            arrayList3.add(new ItemDescriptor(string5 + "_static_gw" + n8, string5));
            arrayList4.add(new ItemDescriptor(string4 + "_static_mask" + n8, string4));
            arrayList5.add(new ItemDescriptor(string3 + "_static_mask" + n8, string3));
            object4 = string15.equals("default") ? "Default" : (string4.equals("255.255.255.255") ? "Host" : "Net");
            arrayList6.add(new ItemDescriptor((String)object4 + "_static_type" + n8, (String)object4));
            ++n8;
        }
        iPBeans.setAdapterBox(new ChoiceDescriptor(string7, string7));
        iPBeans.setIPGateway(string8);
        iPBeans.setTTypeList(arrayList6.toArray(new ItemDescriptor[arrayList6.size()]));
        iPBeans.setTDestinationList(arrayList2.toArray(new ItemDescriptor[arrayList2.size()]));
        iPBeans.setTGatewayList(arrayList3.toArray(new ItemDescriptor[arrayList3.size()]));
        iPBeans.setTSubnetMaskList(arrayList4.toArray(new ItemDescriptor[arrayList4.size()]));
        iPBeans.setTDeviceList(arrayList5.toArray(new ItemDescriptor[arrayList5.size()]));
        string6 = "";
        string12 = NetworkSettings.getFileContents(HOSTNAME_FILE, string14);
        stringTokenizer2 = new StringTokenizer(string12, "\n");
        while (stringTokenizer2.hasMoreTokens()) {
            object6 = stringTokenizer2.nextToken().trim();
            if (((String)object6).length() <= 0) continue;
            string6 = ((String)object6).trim();
        }
        iPBeans.setHostName(string6);
        string12 = NetworkSettings.getFileContents(ETHERNET_CONFIG_FILE, string14);
        object6 = new StringTokenizer(string12, "\n");
        String string16 = "";
        string5 = "";
        while (((StringTokenizer)object6).hasMoreTokens()) {
            string4 = ((StringTokenizer)object6).nextToken().trim();
            if (!string4.startsWith("alias")) continue;
            if ((string4 = string4.substring(5).trim()).startsWith("eth0")) {
                string16 = string4.substring(4).trim();
                continue;
            }
            if (!string4.startsWith("eth1")) continue;
            string5 = string4.substring(4).trim();
        }
        object6 = new StringTokenizer(string12, "\n");
        string4 = "0";
        string3 = "0";
        object4 = "0";
        Object object8 = "0";
        object5 = "0";
        Object object9 = "0";
        while (((StringTokenizer)object6).hasMoreTokens()) {
            string2 = ((StringTokenizer)object6).nextToken().trim();
            if (string2.startsWith("options")) {
                int n11;
                if ((string2 = string2.substring(7).trim()).startsWith("bcm5700")) {
                    String string17;
                    int n12 = (string2 = string2.substring(7).trim()).indexOf("full_duplex=");
                    if (n12 > -1) {
                        string17 = string2.substring(n12 += 12).trim();
                        if (string17.indexOf(" ") > -1) {
                            string17 = string17.substring(0, string17.indexOf(" ")).trim();
                        }
                        if (string17.indexOf(",") > -1) {
                            if (string16.equals("bcm5700")) {
                                object4 = string17.substring(0, string17.indexOf(","));
                            }
                            if (string5.equals("bcm5700")) {
                                object8 = string17.substring(string17.indexOf(",") + 1);
                            }
                        } else {
                            if (string16.equals("bcm5700")) {
                                object4 = string17;
                            }
                            if (string5.equals("bcm5700")) {
                                object8 = string17;
                            }
                        }
                    }
                    if ((n12 = string2.indexOf("line_speed=")) <= -1) continue;
                    string17 = string2.substring(n12 += 11).trim();
                    if (string17.indexOf(" ") > -1) {
                        string17 = string17.substring(0, string17.indexOf(" ")).trim();
                    }
                    if (string17.indexOf(",") > -1) {
                        if (string16.equals("bcm5700")) {
                            object5 = string17.substring(0, string17.indexOf(","));
                        }
                        if (!string5.equals("bcm5700")) continue;
                        object9 = string17.substring(string17.indexOf(",") + 1);
                        continue;
                    }
                    if (string16.equals("bcm5700")) {
                        object5 = string17;
                    }
                    if (!string5.equals("bcm5700")) continue;
                    object9 = string17;
                    continue;
                }
                if (string2.startsWith("e1000")) {
                    int n13 = (string2 = string2.substring(5).trim()).indexOf("Duplex=");
                    if (n13 > -1) {
                        String string18 = string2.substring(n13 += 7).trim();
                        if (string18.indexOf(" ") > -1) {
                            string18 = string18.substring(0, string18.indexOf(" ")).trim();
                        }
                        if (string18.indexOf(",") > -1) {
                            if (string16.equals("e1000")) {
                                object4 = string18.substring(0, string18.indexOf(","));
                            }
                            if (string5.equals("e1000")) {
                                object8 = string18.substring(string18.indexOf(",") + 1);
                            }
                        } else {
                            if (string16.equals("e1000")) {
                                object4 = string18;
                            }
                            if (string5.equals("e1000")) {
                                object8 = string18;
                            }
                        }
                    }
                    if ((n13 = string2.indexOf("Speed=")) <= -1) continue;
                    String string19 = string2.substring(n13 += 6).trim();
                    if (string19.indexOf(" ") > -1) {
                        string19 = string19.substring(0, string19.indexOf(" ")).trim();
                    }
                    if (string19.indexOf(",") > -1) {
                        if (string16.equals("e1000")) {
                            object5 = string19.substring(0, string19.indexOf(","));
                        }
                        if (!string5.equals("e1000")) continue;
                        object9 = string19.substring(string19.indexOf(",") + 1);
                        continue;
                    }
                    if (string16.equals("e1000")) {
                        object5 = string19;
                    }
                    if (!string5.equals("e1000")) continue;
                    object9 = string19;
                    continue;
                }
                if (string2.startsWith("e100")) {
                    int n14 = (string2 = string2.substring(4).trim()).indexOf("e100_speed_duplex=");
                    if (n14 <= -1) continue;
                    if ((string2 = string2.substring(n14 += 18).trim()).indexOf(" ") > -1) {
                        string2 = string2.substring(0, string2.indexOf(" ")).trim();
                    }
                    if (string2.indexOf(",") > -1) {
                        if (string16.equals("e100")) {
                            string4 = string2.substring(0, string2.indexOf(","));
                        }
                        if (!string5.equals("e100")) continue;
                        string3 = string2.substring(string2.indexOf(",") + 1);
                        continue;
                    }
                    if (string16.equals("e100")) {
                        string4 = string2;
                    }
                    if (!string5.equals("e100")) continue;
                    string3 = string2;
                    continue;
                }
                if (!string2.startsWith("eepro100") || (n11 = (string2 = string2.substring(8).trim()).indexOf("options=")) <= -1) continue;
                if ((string2 = string2.substring(n11 += 8).trim()).indexOf(" ") > -1) {
                    string2 = string2.substring(0, string2.indexOf(" ")).trim();
                }
                if (string2.indexOf(",") > -1) {
                    if (string16.equals("eepro100")) {
                        string4 = string2.substring(0, string2.indexOf(","));
                    }
                    if (!string5.equals("eepro100")) continue;
                    string3 = string2.substring(string2.indexOf(",") + 1);
                    continue;
                }
                if (string16.equals("eepro100")) {
                    string4 = string2;
                }
                if (!string5.equals("eepro100")) continue;
                string3 = string2;
                continue;
            }
            if (!string2.startsWith(ETHTOOL_PREFIX) || !(string2 = string2.substring(ETHTOOL_PREFIX.length()).trim()).startsWith("eth0 ") && !string2.startsWith("eth1 ")) continue;
            String string20 = string2.substring(0, 4);
            int n15 = (string2 = string2.substring(4).trim()).indexOf("autoneg ");
            if (n15 <= -1) continue;
            object3 = string2.substring(n15 + 8).trim();
            if ((n15 = ((String)object3).indexOf(" ")) > -1) {
                object3 = ((String)object3).substring(0, n15).trim();
            }
            if (!((String)object3).equals("off")) continue;
            n15 = string2.indexOf("speed ");
            if (n15 > -1) {
                object3 = string2.substring(n15 + 6).trim();
                if ((n15 = ((String)object3).indexOf(" ")) > -1) {
                    object3 = ((String)object3).substring(0, n15).trim();
                }
                if (string20.equals("eth0")) {
                    object5 = object3;
                } else if (string20.equals("eth1")) {
                    object9 = object3;
                }
            }
            if ((n15 = string2.indexOf("duplex ")) <= -1) continue;
            object3 = string2.substring(n15 + 7).trim();
            if ((n15 = ((String)object3).indexOf(" ")) > -1) {
                object3 = ((String)object3).substring(0, n15).trim();
            }
            if (string20.equals("eth0")) {
                object4 = object3;
                continue;
            }
            if (!string20.equals("eth1")) continue;
            object8 = object3;
        }
        if (string16.equals("eepro100")) {
            if (string4.equalsIgnoreCase("0x40")) {
                string4 = "1";
            } else if (string4.equalsIgnoreCase("0x50")) {
                string4 = "2";
            } else if (string4.equalsIgnoreCase("0x20")) {
                string4 = "3";
            } else if (string4.equalsIgnoreCase("0x30")) {
                string4 = "4";
            }
        }
        if (string5.equals("eepro100")) {
            if (string3.equalsIgnoreCase("0x40")) {
                string3 = "1";
            } else if (string3.equalsIgnoreCase("0x50")) {
                string3 = "2";
            } else if (string3.equalsIgnoreCase("0x20")) {
                string3 = "3";
            } else if (string3.equalsIgnoreCase("0x30")) {
                string3 = "4";
            }
        }
        if (string16.equals("e1000")) {
            string4 = ((String)object4).equals("1") && ((String)object5).equals("10") ? "1" : (((String)object4).equals("1") && ((String)object5).equals("100") ? "3" : (((String)object4).equals("1") && ((String)object5).equals("1000") ? "5" : (((String)object4).equals("2") && ((String)object5).equals("10") ? "2" : (((String)object4).equals("2") && ((String)object5).equals("100") ? "4" : (((String)object4).equals("2") && ((String)object5).equals("1000") ? "6" : "0")))));
        }
        if (string5.equals("e1000")) {
            string3 = ((String)object8).equals("1") && ((String)object9).equals("10") ? "1" : (((String)object8).equals("1") && ((String)object9).equals("100") ? "3" : (((String)object8).equals("1") && ((String)object9).equals("1000") ? "5" : (((String)object8).equals("2") && ((String)object9).equals("10") ? "2" : (((String)object8).equals("2") && ((String)object9).equals("100") ? "4" : (((String)object8).equals("2") && ((String)object9).equals("1000") ? "6" : "0")))));
        }
        if (string16.equals("bcm5700")) {
            string4 = ((String)object4).equals("0") && ((String)object5).equals("10") ? "1" : (((String)object4).equals("0") && ((String)object5).equals("100") ? "3" : (((String)object4).equals("0") && ((String)object5).equals("1000") ? "5" : (((String)object4).equals("1") && ((String)object5).equals("10") ? "2" : (((String)object4).equals("1") && ((String)object5).equals("100") ? "4" : (((String)object4).equals("1") && ((String)object5).equals("1000") ? "6" : "0")))));
        }
        if (string5.equals("bcm5700")) {
            string3 = ((String)object8).equals("0") && ((String)object9).equals("10") ? "1" : (((String)object8).equals("0") && ((String)object9).equals("100") ? "3" : (((String)object8).equals("0") && ((String)object9).equals("1000") ? "5" : (((String)object8).equals("1") && ((String)object9).equals("10") ? "2" : (((String)object8).equals("1") && ((String)object9).equals("100") ? "4" : (((String)object8).equals("1") && ((String)object9).equals("1000") ? "6" : "0")))));
        }
        if (string16.equals("tg3")) {
            string4 = ((String)object4).equals("half") && ((String)object5).equals("10") ? "1" : (((String)object4).equals("half") && ((String)object5).equals("100") ? "3" : (((String)object4).equals("half") && ((String)object5).equals("1000") ? "5" : (((String)object4).equals("full") && ((String)object5).equals("10") ? "2" : (((String)object4).equals("full") && ((String)object5).equals("100") ? "4" : (((String)object4).equals("full") && ((String)object5).equals("1000") ? "6" : "0")))));
        }
        if (string5.equals("tg3")) {
            string3 = ((String)object8).equals("half") && ((String)object9).equals("10") ? "1" : (((String)object8).equals("half") && ((String)object9).equals("100") ? "3" : (((String)object8).equals("half") && ((String)object9).equals("1000") ? "5" : (((String)object8).equals("full") && ((String)object9).equals("10") ? "2" : (((String)object8).equals("full") && ((String)object9).equals("100") ? "4" : (((String)object8).equals("full") && ((String)object9).equals("1000") ? "6" : "0")))));
        }
        if (string16.equals("e100") && string5.equals("eepro100")) {
            string16 = "eepro100";
            string3 = string4;
        } else if (string16.equals("eepro100") && string5.equals("e100")) {
            string5 = "eepro100";
            string3 = string4;
        }
        string2 = NetworkSettings.getCorrectedMediaSpeed(string4, true);
        String string21 = NetworkSettings.getCorrectedMediaSpeed(string3, true);
        iPBeans.setMediaSpeedString(string2);
        iPBeans.setDriver0(string16);
        iPBeans.setMediaSpeed1String(string21);
        iPBeans.setDriver1(string5);
        string12 = NetworkSettings.getFileContents(HOSTS_FILE, string14);
        StringTokenizer stringTokenizer4 = new StringTokenizer(string12, "\n");
        object3 = new ArrayList();
        ArrayList<ItemDescriptor> arrayList7 = new ArrayList<ItemDescriptor>();
        int n16 = 0;
        String string22 = iPBeans.getIPAddr0() == null ? "" : iPBeans.getIPAddr0().trim();
        String string23 = iPBeans.getIPAddr1() == null ? "" : iPBeans.getIPAddr1().trim();
        while (stringTokenizer4.hasMoreTokens()) {
            object2 = stringTokenizer4.nextToken().trim();
            if (((String)object2).startsWith("#") || ((String)object2).length() == 0 || !(stringTokenizer = new StringTokenizer((String)object2)).hasMoreTokens() || (string = stringTokenizer.nextToken()).equals("127.0.0.1") || string.equals(string22) || string.equals(string23)) continue;
            serializable = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                ((StringBuffer)serializable).append(stringTokenizer.nextToken().trim());
                ((StringBuffer)serializable).append(' ');
            }
            object = ((StringBuffer)serializable).toString().trim();
            ((ArrayList)object3).add(new ItemDescriptor(String.valueOf(n16++) + "_addr", string));
            arrayList7.add(new ItemDescriptor((String)object + "_host", (String)object));
        }
        iPBeans.setTIPAddrList(((ArrayList)object3).toArray(new ItemDescriptor[((ArrayList)object3).size()]));
        iPBeans.setTHostNamesList(arrayList7.toArray(new ItemDescriptor[arrayList7.size()]));
        Trace.trace(TRACE_MASKF, "NetworkSettings.GetIPSettings() getting DNS settings");
        object2 = new NameDNSBean();
        string12 = NetworkSettings.getFileContents(DNS_FILE, string14);
        stringTokenizer = new StringTokenizer(string12, "\n");
        string = "";
        serializable = new ArrayList();
        object = new ArrayList();
        int n17 = 0;
        int n18 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            Object object10;
            String string24 = stringTokenizer.nextToken().trim();
            if (string24.startsWith("domain")) {
                string = string24.substring(6).trim();
                continue;
            }
            if (string24.startsWith("nameserver")) {
                object10 = string24.substring(10).trim();
                if (((String)object10).length() <= 0) continue;
                ((ArrayList)serializable).add(new ItemDescriptor(String.valueOf(n17++), (String)object10));
                continue;
            }
            if (!string24.startsWith("search")) continue;
            ((ArrayList)object).clear();
            n18 = 0;
            object10 = new StringTokenizer(string24.substring(6));
            while (((StringTokenizer)object10).hasMoreTokens()) {
                ((ArrayList)object).add(new ItemDescriptor(String.valueOf(n18++) + "_suffix", ((StringTokenizer)object10).nextToken()));
            }
        }
        ((NameDNSBean)object2).setDNSEnabled(string12.length() > 0);
        ((NameDNSBean)object2).setDomainName(string);
        ((NameDNSBean)object2).setDNSServersList(((ArrayList)serializable).toArray(new ItemDescriptor[n17]));
        if (n17 > 0) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = "0";
        } else {
            stringArray2 = null;
        }
        ((NameDNSBean)object2).setDNSServersSelection(stringArray2);
        ((NameDNSBean)object2).setDomainSuffixesList(((ArrayList)object).toArray(new ItemDescriptor[n18]));
        if (n18 > 0) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = "0";
        } else {
            stringArray = null;
        }
        ((NameDNSBean)object2).setDomainSuffixesSelection(stringArray);
        Trace.trace(TRACE_MASKF, "NetworkSettings.GetIPSettings() got DNS settings");
        Trace.trace(TRACE_MASKT, "<- NetworkSettings.GetIPSettings()");
        return new DataBean[]{iPBeans, object2};
    }

    public static void SetIPSettings(IPBeans iPBeans, NameDNSBean nameDNSBean) throws IOException {
        String string;
        Object object;
        Object object2;
        ItemDescriptor[] itemDescriptorArray;
        ItemDescriptor[] itemDescriptorArray2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string2;
        Trace.trace(TRACE_MASKT, "-> NetworkSettings.SetIPSettings()");
        IOException iOException = null;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String[] stringArray = new String[2];
        int n = 0;
        while (n < stringArray.length) {
            string2 = iPBeans.getDevName(n);
            if (string2 != null && string2.trim().length() > 0) {
                stringArray[n] = "/etc/sysconfig/network/ifcfg-" + string2.trim();
                arrayList2.add(stringArray[n]);
            }
            ++n;
        }
        arrayList2.add(HOSTS_FILE);
        arrayList2.add(ETHERNET_CONFIG_FILE);
        arrayList2.add(STATIC_ROUTES_FILE);
        arrayList2.add(DNS_FILE);
        arrayList2.add(HOSTNAME_FILE);
        string2 = NetworkSettings.readMultipleFileContents(arrayList2);
        int n2 = 0;
        while (n2 < stringArray.length) {
            object6 = stringArray[n2];
            if (object6 != null && ((String)object6).length() != 0) {
                try {
                    object5 = NetworkSettings.getFileContents((String)object6, string2);
                    object4 = new StringReader((String)object5);
                    object3 = new BufferedReader((Reader)object4);
                    itemDescriptorArray2 = new StringWriter(((String)object5).length());
                    itemDescriptorArray = null;
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    while ((itemDescriptorArray = ((BufferedReader)object3).readLine()) != null) {
                        if (0 == itemDescriptorArray.indexOf("IPADDR=")) {
                            itemDescriptorArray = "IPADDR='" + iPBeans.getIPAddr(n2) + "'";
                            bl = true;
                        } else if (0 == itemDescriptorArray.indexOf("NETMASK=")) {
                            itemDescriptorArray = "NETMASK='" + iPBeans.getMask(n2) + "'";
                            bl2 = true;
                        } else if (0 == itemDescriptorArray.indexOf("BOOTPROTO=")) {
                            itemDescriptorArray = "BOOTPROTO='static'";
                            bl3 = true;
                        }
                        itemDescriptorArray2.write((String)itemDescriptorArray);
                        itemDescriptorArray2.write("\n");
                    }
                    if (!bl && iPBeans.getIPAddr(n2).trim().length() > 0) {
                        itemDescriptorArray = "IPADDR='" + iPBeans.getIPAddr(n2) + "'";
                        itemDescriptorArray2.write((String)itemDescriptorArray);
                        itemDescriptorArray2.write("\n");
                    }
                    if (!bl2 && iPBeans.getMask(n2).trim().length() > 0) {
                        itemDescriptorArray = "NETMASK='" + iPBeans.getMask(n2) + "'";
                        itemDescriptorArray2.write((String)itemDescriptorArray);
                        itemDescriptorArray2.write("\n");
                    }
                    if (!bl3) {
                        itemDescriptorArray = "BOOTPROTO='static'";
                        itemDescriptorArray2.write((String)itemDescriptorArray);
                        itemDescriptorArray2.write("\n");
                    }
                    itemDescriptorArray2.close();
                    NetworkSettings.prepareFileRewrite((String)object6, itemDescriptorArray2.toString(), (String)object5, stringBuffer, arrayList);
                }
                catch (IOException iOException2) {
                    Trace.trace(TRACE_MASKD, "I/O Exception " + iOException2);
                    new AusMicrocodeLog(_logInfo, 12, iOException2).writeEntry(null);
                    iOException = iOException2;
                }
            }
            ++n2;
        }
        try {
            object6 = NetworkSettings.getFileContents(HOSTNAME_FILE, string2);
            object5 = new StringWriter(((String)object6).length());
            object4 = iPBeans.getHostName();
            if (object4 != null) {
                ((StringWriter)object5).write((String)object4);
                ((StringWriter)object5).write("\n");
            }
            ((StringWriter)object5).close();
            NetworkSettings.prepareFileRewrite(HOSTNAME_FILE, ((StringWriter)object5).toString(), (String)object6, stringBuffer, arrayList);
        }
        catch (IOException iOException3) {
            Trace.trace(TRACE_MASKD, "I/O Exception " + iOException3);
            new AusMicrocodeLog(_logInfo, 12, iOException3).writeEntry(null);
            iOException = iOException3;
        }
        try {
            String string3;
            object6 = NetworkSettings.getFileContents(HOSTS_FILE, string2);
            object5 = new StringWriter(((String)object6).length());
            object4 = new HashMap<String, String>();
            object3 = iPBeans.getTIPAddrList();
            itemDescriptorArray2 = iPBeans.getTHostNamesList();
            if (object3 != null && itemDescriptorArray2 != null) {
                int n3 = 0;
                while (n3 < ((ItemDescriptor[])object3).length) {
                    ((HashMap)object4).put(object3[n3].getTitle(), itemDescriptorArray2[n3].getTitle());
                    ++n3;
                }
            }
            itemDescriptorArray = iPBeans.getIPAddr0() == null ? "" : iPBeans.getIPAddr0().trim();
            String string4 = iPBeans.getIPAddr1() == null ? "" : iPBeans.getIPAddr1().trim();
            String string5 = string3 = iPBeans.getHostName() == null ? "" : iPBeans.getHostName().trim();
            if (string3.length() > 0) {
                String string6 = string3 + (string3.indexOf(".") == -1 ? "" : " " + string3.substring(0, string3.indexOf(".")));
                object2 = ((ChoiceDescriptor)iPBeans.getAdapterBox()).getName().trim();
                if (((String)object2).equals(iPBeans.getDevName1().trim()) && string4.length() != 0) {
                    ((HashMap)object4).put(string4, string6);
                } else if (itemDescriptorArray.length() != 0) {
                    ((HashMap)object4).put(itemDescriptorArray, string6);
                } else if (string4.length() != 0) {
                    ((HashMap)object4).put(string4, string6);
                }
            }
            ((HashMap)object4).put("127.0.0.1", "localhost.localdomain localhost");
            StringTokenizer stringTokenizer = new StringTokenizer((String)object6, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                object2 = stringTokenizer.nextToken();
                if (((String)object2).startsWith("#")) {
                    ((StringWriter)object5).write((String)object2);
                    ((StringWriter)object5).write("\n");
                    continue;
                }
                object = new StringTokenizer((String)object2);
                if (!((StringTokenizer)object).hasMoreTokens() || !((HashMap)object4).containsKey(string = ((StringTokenizer)object).nextToken())) continue;
                ((StringWriter)object5).write(string);
                ((StringWriter)object5).write("\t");
                ((StringWriter)object5).write((String)((HashMap)object4).get(string));
                ((StringWriter)object5).write("\n");
                ((HashMap)object4).remove(string);
            }
            object2 = ((HashMap)object4).keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                ((StringWriter)object5).write((String)object);
                ((StringWriter)object5).write("\t");
                ((StringWriter)object5).write((String)((HashMap)object4).get(object));
                ((StringWriter)object5).write("\n");
            }
            ((StringWriter)object5).close();
            NetworkSettings.prepareFileRewrite(HOSTS_FILE, ((StringWriter)object5).toString(), (String)object6, stringBuffer, arrayList);
        }
        catch (IOException iOException4) {
            Trace.trace(TRACE_MASKD, "I/O Exception " + iOException4);
            new AusMicrocodeLog(_logInfo, 12, iOException4).writeEntry(null);
            iOException = iOException4;
        }
        try {
            object6 = NetworkSettings.getFileContents(STATIC_ROUTES_FILE, string2);
            object5 = new StringWriter(((String)object6).length());
            Object object7 = object4 = iPBeans.getIPGateway() == null ? "" : iPBeans.getIPGateway().trim();
            if (((String)object4).length() > 0) {
                object3 = "";
                if (iPBeans.getAdapterBox() != null) {
                    object3 = ((ChoiceDescriptor)iPBeans.getAdapterBox()).getName();
                }
                if (object3 != null && ((String)object3).trim().length() > 0) {
                    ((StringWriter)object5).write("default " + (String)object4 + " - " + (String)object3 + "\n");
                } else {
                    ((StringWriter)object5).write("default " + (String)object4 + " - -\n");
                }
            }
            if ((object3 = iPBeans.getTDestinationList()) != null && ((ItemDescriptor[])object3).length != 0) {
                itemDescriptorArray2 = iPBeans.getTSubnetMaskList();
                itemDescriptorArray = iPBeans.getTGatewayList();
                ItemDescriptor[] itemDescriptorArray3 = iPBeans.getTDeviceList();
                int n4 = 0;
                while (n4 < ((Object)object3).length) {
                    String string7 = object3[n4].getTitle();
                    object2 = itemDescriptorArray2[n4].getTitle();
                    object = itemDescriptorArray[n4].getTitle();
                    string = itemDescriptorArray3[n4].getTitle();
                    ((StringWriter)object5).write(string7);
                    ((StringWriter)object5).write(" ");
                    ((StringWriter)object5).write((String)object);
                    ((StringWriter)object5).write(" ");
                    ((StringWriter)object5).write((String)object2);
                    ((StringWriter)object5).write(" ");
                    ((StringWriter)object5).write(string);
                    ((StringWriter)object5).write("\n");
                    ++n4;
                }
            }
            ((StringWriter)object5).close();
            NetworkSettings.prepareFileRewrite(STATIC_ROUTES_FILE, ((StringWriter)object5).toString(), (String)object6, stringBuffer, arrayList);
        }
        catch (IOException iOException5) {
            Trace.trace(TRACE_MASKD, "I/O Exception " + iOException5);
            new AusMicrocodeLog(_logInfo, 14, iOException5).writeEntry(null);
            iOException = iOException5;
        }
        try {
            String string8;
            String string9;
            String string10;
            object6 = NetworkSettings.getFileContents(ETHERNET_CONFIG_FILE, string2);
            object5 = new StringReader((String)object6);
            object4 = new BufferedReader((Reader)object5);
            object3 = new StringWriter(((String)object6).length());
            boolean bl = ((String)object6).startsWith("alias eth0") || ((String)object6).indexOf("\nalias eth0") > -1;
            boolean bl4 = ((String)object6).startsWith("alias eth1") || ((String)object6).indexOf("\nalias eth1") > -1;
            String string11 = iPBeans.getDriver0();
            String string12 = iPBeans.getDriver1();
            if (string11.length() > 0 && !bl) {
                ((StringWriter)object3).write("alias eth0 " + string11 + "\n");
            }
            if (string12.length() > 0 && !bl4) {
                ((StringWriter)object3).write("alias eth1 " + string12 + "\n");
            }
            String string13 = null;
            object2 = "";
            object = "";
            string = "";
            String string14 = "";
            while ((string13 = ((BufferedReader)object4).readLine()) != null) {
                if ((string13 = string13.trim()).startsWith("alias")) {
                    if (string13.substring(5).trim().startsWith("eth0") && string11.length() > 0) {
                        ((StringWriter)object3).write("alias eth0 " + string11 + "\n");
                        continue;
                    }
                    if (string13.substring(5).trim().startsWith("eth1") && string12.length() > 0) {
                        ((StringWriter)object3).write("alias eth1 " + string12 + "\n");
                        continue;
                    }
                } else if (string13.startsWith("options")) {
                    StringTokenizer stringTokenizer;
                    string10 = string13.substring(7).trim();
                    if (string10.startsWith("e100 ")) {
                        stringTokenizer = new StringTokenizer(string10.substring(4).trim(), " ");
                        object2 = "";
                        while (stringTokenizer.hasMoreTokens()) {
                            string9 = stringTokenizer.nextToken();
                            if (string9.startsWith("e100_speed_duplex=")) continue;
                            object2 = (String)object2 + " " + string9;
                        }
                        continue;
                    }
                    if (string10.startsWith("eepro100 ")) {
                        stringTokenizer = new StringTokenizer(string10.substring(8).trim(), " ");
                        object = "";
                        while (stringTokenizer.hasMoreTokens()) {
                            string9 = stringTokenizer.nextToken();
                            if (string9.startsWith("options=")) continue;
                            object = (String)object + " " + string9;
                        }
                        continue;
                    }
                    if (string10.startsWith("e1000 ")) {
                        stringTokenizer = new StringTokenizer(string10.substring(5).trim(), " ");
                        string = "";
                        while (stringTokenizer.hasMoreTokens()) {
                            string9 = stringTokenizer.nextToken();
                            if (string9.startsWith("Speed=") || string9.startsWith("Duplex=")) continue;
                            string = string + " " + string9;
                        }
                        continue;
                    }
                    if (string10.startsWith("bcm5700 ")) {
                        stringTokenizer = new StringTokenizer(string10.substring(7).trim(), " ");
                        string14 = "";
                        while (stringTokenizer.hasMoreTokens()) {
                            string9 = stringTokenizer.nextToken();
                            if (string9.startsWith("line_speed=") || string9.startsWith("full_duplex=")) continue;
                            string14 = string14 + " " + string9;
                        }
                        continue;
                    }
                } else if (string13.startsWith(ETHTOOL_PREFIX)) continue;
                ((StringWriter)object3).write(string13);
                ((StringWriter)object3).write("\n");
            }
            string10 = iPBeans.getMediaSpeedString();
            int n5 = (string10 = NetworkSettings.getCorrectedMediaSpeed(string10, false)).indexOf("_median");
            if (n5 > 0) {
                string10 = string9 = string10.substring(0, n5);
            }
            if (string11.equals("eepro100")) {
                if (string10.equals("1")) {
                    string10 = "0x40";
                } else if (string10.equals("2")) {
                    string10 = "0x50";
                } else if (string10.equals("3")) {
                    string10 = "0x20";
                } else if (string10.equals("4")) {
                    string10 = "0x30";
                }
            }
            string9 = "0";
            String string15 = "0";
            if (string11.equals("e1000")) {
                if (string10.equals("1")) {
                    string9 = "10";
                    string15 = "1";
                } else if (string10.equals("2")) {
                    string9 = "10";
                    string15 = "2";
                } else if (string10.equals("3")) {
                    string9 = "100";
                    string15 = "1";
                } else if (string10.equals("4")) {
                    string9 = "100";
                    string15 = "2";
                } else if (string10.equals("5")) {
                    string9 = "1000";
                    string15 = "1";
                } else if (string10.equals("6")) {
                    string9 = "1000";
                    string15 = "2";
                }
            } else if (string11.equals("bcm5700")) {
                if (string10.equals("1")) {
                    string9 = "10";
                    string15 = "0";
                } else if (string10.equals("2")) {
                    string9 = "10";
                    string15 = "1";
                } else if (string10.equals("3")) {
                    string9 = "100";
                    string15 = "0";
                } else if (string10.equals("4")) {
                    string9 = "100";
                    string15 = "1";
                } else if (string10.equals("5")) {
                    string9 = "1000";
                    string15 = "0";
                } else if (string10.equals("6")) {
                    string9 = "1000";
                    string15 = "1";
                }
            } else if (string11.equals("tg3")) {
                if (string10.equals("1")) {
                    string9 = "10";
                    string15 = "half";
                } else if (string10.equals("2")) {
                    string9 = "10";
                    string15 = "full";
                } else if (string10.equals("3")) {
                    string9 = "100";
                    string15 = "half";
                } else if (string10.equals("4")) {
                    string9 = "100";
                    string15 = "full";
                } else if (string10.equals("5")) {
                    string9 = "1000";
                    string15 = "half";
                } else if (string10.equals("6")) {
                    string9 = "1000";
                    string15 = "full";
                }
            }
            String string16 = iPBeans.getMediaSpeed1String();
            string16 = NetworkSettings.getCorrectedMediaSpeed(string16, false);
            n5 = string16.indexOf("_median");
            if (n5 > 0) {
                string16 = string8 = string16.substring(0, n5);
            }
            if (string12.equals("eepro100")) {
                if (string16.equals("1")) {
                    string16 = "0x40";
                } else if (string16.equals("2")) {
                    string16 = "0x50";
                } else if (string16.equals("3")) {
                    string16 = "0x20";
                } else if (string16.equals("4")) {
                    string16 = "0x30";
                }
            }
            string8 = "0";
            String string17 = "0";
            if (string12.equals("e1000")) {
                if (string16.equals("1")) {
                    string8 = "10";
                    string17 = "1";
                } else if (string16.equals("2")) {
                    string8 = "10";
                    string17 = "2";
                } else if (string16.equals("3")) {
                    string8 = "100";
                    string17 = "1";
                } else if (string16.equals("4")) {
                    string8 = "100";
                    string17 = "2";
                } else if (string16.equals("5")) {
                    string8 = "1000";
                    string17 = "1";
                } else if (string16.equals("6")) {
                    string8 = "1000";
                    string17 = "2";
                }
            } else if (string12.equals("bcm5700")) {
                if (string16.equals("1")) {
                    string8 = "10";
                    string17 = "0";
                } else if (string16.equals("2")) {
                    string8 = "10";
                    string17 = "1";
                } else if (string16.equals("3")) {
                    string8 = "100";
                    string17 = "0";
                } else if (string16.equals("4")) {
                    string8 = "100";
                    string17 = "1";
                } else if (string10.equals("5")) {
                    string8 = "1000";
                    string17 = "0";
                } else if (string10.equals("6")) {
                    string8 = "1000";
                    string17 = "1";
                }
            } else if (string12.equals("tg3")) {
                if (string16.equals("1")) {
                    string8 = "10";
                    string17 = "half";
                } else if (string16.equals("2")) {
                    string8 = "10";
                    string17 = "full";
                } else if (string16.equals("3")) {
                    string8 = "100";
                    string17 = "half";
                } else if (string16.equals("4")) {
                    string8 = "100";
                    string17 = "full";
                } else if (string16.equals("5")) {
                    string8 = "1000";
                    string17 = "half";
                } else if (string16.equals("6")) {
                    string8 = "1000";
                    string17 = "full";
                }
            }
            if (string11.equals("e100") && string12.equals("e100")) {
                ((StringWriter)object3).write("options e100");
                ((StringWriter)object3).write((String)object2);
                ((StringWriter)object3).write(" e100_speed_duplex=");
                ((StringWriter)object3).write(string10);
                ((StringWriter)object3).write(",");
                ((StringWriter)object3).write(string16);
                ((StringWriter)object3).write("\n");
            } else if (string11.equals("eepro100") && string12.equals("eepro100")) {
                ((StringWriter)object3).write("options eepro100");
                ((StringWriter)object3).write((String)object);
                ((StringWriter)object3).write(" options=");
                ((StringWriter)object3).write(string10);
                ((StringWriter)object3).write(",");
                ((StringWriter)object3).write(string16);
                ((StringWriter)object3).write("\n");
            } else if (string11.equals("e1000") && string12.equals("e1000")) {
                ((StringWriter)object3).write("options e1000");
                ((StringWriter)object3).write(string);
                ((StringWriter)object3).write(" Duplex=");
                ((StringWriter)object3).write(string15);
                ((StringWriter)object3).write(",");
                ((StringWriter)object3).write(string17);
                ((StringWriter)object3).write(" Speed=");
                ((StringWriter)object3).write(string9);
                ((StringWriter)object3).write(",");
                ((StringWriter)object3).write(string8);
                ((StringWriter)object3).write("\n");
            } else if (string11.equals("bcm5700") && string12.equals("bcm5700")) {
                ((StringWriter)object3).write("options bcm5700");
                ((StringWriter)object3).write(string14);
                ((StringWriter)object3).write(" line_speed=");
                ((StringWriter)object3).write(string9);
                ((StringWriter)object3).write(",");
                ((StringWriter)object3).write(string8);
                ((StringWriter)object3).write(" full_duplex=");
                ((StringWriter)object3).write(string15);
                ((StringWriter)object3).write(",");
                ((StringWriter)object3).write(string17);
                ((StringWriter)object3).write("\n");
            } else {
                if (string11.equals("e100")) {
                    ((StringWriter)object3).write("options e100");
                    ((StringWriter)object3).write((String)object2);
                    ((StringWriter)object3).write(" e100_speed_duplex=");
                    ((StringWriter)object3).write(string10);
                    ((StringWriter)object3).write("\n");
                } else if (string11.equals("eepro100")) {
                    ((StringWriter)object3).write("options eepro100");
                    ((StringWriter)object3).write((String)object);
                    ((StringWriter)object3).write(" options=");
                    ((StringWriter)object3).write(string10);
                    ((StringWriter)object3).write("\n");
                } else if (string11.equals("e1000")) {
                    ((StringWriter)object3).write("options e1000");
                    ((StringWriter)object3).write(string);
                    ((StringWriter)object3).write(" Duplex=");
                    ((StringWriter)object3).write(string15);
                    ((StringWriter)object3).write(" Speed=");
                    ((StringWriter)object3).write(string9);
                    ((StringWriter)object3).write("\n");
                } else if (string11.equals("bcm5700")) {
                    ((StringWriter)object3).write("options bcm5700");
                    ((StringWriter)object3).write(string14);
                    ((StringWriter)object3).write(" line_speed=");
                    ((StringWriter)object3).write(string9);
                    ((StringWriter)object3).write(" full_duplex=");
                    ((StringWriter)object3).write(string15);
                    ((StringWriter)object3).write("\n");
                } else if (string11.equals("tg3")) {
                    ((StringWriter)object3).write(ETHTOOL_PREFIX);
                    if (string9.equals("0")) {
                        ((StringWriter)object3).write("eth0 autoneg on\n");
                    } else {
                        ((StringWriter)object3).write("eth0 autoneg off speed ");
                        ((StringWriter)object3).write(string9);
                        ((StringWriter)object3).write(" duplex ");
                        ((StringWriter)object3).write(string15);
                        ((StringWriter)object3).write("\n");
                    }
                }
                if (string12.equals("e100")) {
                    ((StringWriter)object3).write("options e100");
                    ((StringWriter)object3).write((String)object2);
                    ((StringWriter)object3).write(" e100_speed_duplex=");
                    ((StringWriter)object3).write(string16);
                    ((StringWriter)object3).write("\n");
                } else if (string12.equals("eepro100")) {
                    ((StringWriter)object3).write("options eepro100");
                    ((StringWriter)object3).write((String)object);
                    ((StringWriter)object3).write(" options=");
                    ((StringWriter)object3).write(string16);
                    ((StringWriter)object3).write("\n");
                } else if (string12.equals("e1000")) {
                    ((StringWriter)object3).write("options e1000");
                    ((StringWriter)object3).write(string);
                    ((StringWriter)object3).write(" Duplex=");
                    ((StringWriter)object3).write(string17);
                    ((StringWriter)object3).write(" Speed=");
                    ((StringWriter)object3).write(string8);
                    ((StringWriter)object3).write("\n");
                } else if (string12.equals("bcm5700")) {
                    ((StringWriter)object3).write("options bcm5700");
                    ((StringWriter)object3).write(string14);
                    ((StringWriter)object3).write(" line_speed=");
                    ((StringWriter)object3).write(string8);
                    ((StringWriter)object3).write(" full_duplex=");
                    ((StringWriter)object3).write(string17);
                    ((StringWriter)object3).write("\n");
                } else if (string12.equals("tg3")) {
                    ((StringWriter)object3).write(ETHTOOL_PREFIX);
                    if (string8.equals("0")) {
                        ((StringWriter)object3).write("eth1 autoneg on\n");
                    } else {
                        ((StringWriter)object3).write("eth1 autoneg off speed ");
                        ((StringWriter)object3).write(string8);
                        ((StringWriter)object3).write(" duplex ");
                        ((StringWriter)object3).write(string17);
                        ((StringWriter)object3).write("\n");
                    }
                }
            }
            ((BufferedReader)object4).close();
            ((StringWriter)object3).close();
            NetworkSettings.prepareFileRewrite(ETHERNET_CONFIG_FILE, ((StringWriter)object3).toString(), (String)object6, stringBuffer, arrayList);
        }
        catch (IOException iOException6) {
            Trace.trace(TRACE_MASKD, "I/O Exception " + iOException6);
            new AusMicrocodeLog(_logInfo, 12, iOException6).writeEntry(null);
            iOException = iOException6;
        }
        try {
            object6 = NetworkSettings.getFileContents(DNS_FILE, string2);
            object5 = new StringWriter(((String)object6).length());
            if (nameDNSBean.isDNSEnabled()) {
                if (nameDNSBean.getDomainName() != null && nameDNSBean.getDomainName().length() > 0) {
                    object4 = "domain " + nameDNSBean.getDomainName();
                    ((StringWriter)object5).write((String)object4);
                    ((StringWriter)object5).write("\n");
                }
                if ((object4 = nameDNSBean.getDomainSuffixesList()) != null && ((ItemDescriptor[])object4).length != 0) {
                    object3 = "search";
                    int n6 = 0;
                    while (n6 < ((ItemDescriptor[])object4).length) {
                        object3 = (String)object3 + " " + object4[n6].getTitle();
                        ++n6;
                    }
                    ((StringWriter)object5).write((String)object3);
                    ((StringWriter)object5).write("\n");
                }
                if ((object4 = nameDNSBean.getDNSServersList()) != null) {
                    int n7 = 0;
                    while (n7 < ((ItemDescriptor[])object4).length) {
                        String string18 = "nameserver " + object4[n7].getTitle();
                        ((StringWriter)object5).write(string18);
                        ((StringWriter)object5).write("\n");
                        ++n7;
                    }
                }
            }
            ((StringWriter)object5).close();
            NetworkSettings.prepareFileRewrite(DNS_FILE, ((StringWriter)object5).toString(), (String)object6, stringBuffer, arrayList);
        }
        catch (IOException iOException7) {
            Trace.trace(TRACE_MASKD, "I/O Exception " + iOException7);
            new AusMicrocodeLog(_logInfo, 18, iOException7).writeEntry(null);
            iOException = iOException7;
        }
        if (stringBuffer.length() > 0) {
            NetworkSettings.executeCommand(stringBuffer.toString());
            object6 = arrayList.listIterator();
            while (object6.hasNext()) {
                ((File)object6.next()).delete();
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        Trace.trace(TRACE_MASKT, "<- NetworkSettings.SetIPSettings()");
    }

    private static String executeCommandGetStdOut(String string) {
        Trace.trace(TRACE_MASKT, "-> NetworkSettings.executeCommandGetStdOut()");
        Trace.trace(TRACE_MASKF, "   about to attempt " + string);
        String string2 = "";
        EExecResult eExecResult = EExec.Exec((String)string);
        if (eExecResult.rc == 0) {
            Trace.trace(TRACE_MASKF, "<" + string + "> executed successfully");
            if (eExecResult.stdout != null) {
                string2 = eExecResult.stdout;
            } else {
                Trace.trace(TRACE_MASKF, "command returned successfully, but with no data");
                AusMicrocodeLog ausMicrocodeLog = new AusMicrocodeLog(_logInfo, 3);
                ausMicrocodeLog.add("command " + string + " returned successfully, but with no data. ");
                ausMicrocodeLog.writeEntry(null);
            }
        } else {
            Trace.trace(TRACE_MASKF, "command returned non-zero return code, rc = " + eExecResult.rc);
            Trace.trace(TRACE_MASKF, "stderr data is <" + eExecResult.stderr.trim() + ">");
            AusMicrocodeLog ausMicrocodeLog = new AusMicrocodeLog(_logInfo, 20);
            ausMicrocodeLog.add("command " + string + " execution error, rc = " + eExecResult.rc);
            ausMicrocodeLog.writeEntry(null);
        }
        Trace.trace(TRACE_MASKT, "<- NetworkSettings.executeCommandGetStdOut()");
        return string2;
    }

    private static int executeCommand(String string) {
        Trace.trace(TRACE_MASKT, "-> NetworkSettings.executeCommand()");
        Trace.trace(TRACE_MASKF, "   about to attempt " + string);
        EExecResult eExecResult = EExec.Exec((String)string);
        Trace.trace(TRACE_MASKF, "   command return value is " + eExecResult.rc);
        Trace.trace(TRACE_MASKT, "<- NetworkSettings.executeCommand()");
        return eExecResult.rc;
    }
}

